/**
 * UniFi Device Search tool
 *
 * Copyright (c) 2020, Art of WiFi, info@artofwifi.net
 *
 * This source file is part of the UniFi Device Search tool and is subject to the MIT license that is bundled
 * with this package in the file LICENSE.md.
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/**
 * initialize some vars for later use
 */
var theme                = 'bootstrap',
    alert_message        = '',
    controller = {
        idx:             '',
        full_name:       $('#navbar_controller_dropdown_link').text(),
        config_complete: false,
        stats:           {}
    };

/**
 * check whether user has stored a custom theme, if yes we switch to the stored value
 */
if (localStorage.getItem('udst2_theme') == null || localStorage.getItem('udst2_theme') === 'bootstrap') {
    $('#bootstrap').addClass('active').find('a').append(' <i class="fas fa-check"></i>');
} else {
    var stored_theme = localStorage.getItem('udst2_theme');
    switchCSS(stored_theme);
}

/**
 * catch a Bootswatch CSS stylesheet change request
 */
$('.theme_option').on('click', function(){
    if (!$(this).hasClass('active')) {
        switchCSS($(this).data('theme_name'));
    }
});

/**
 * function to process the CSS switch
 */
function switchCSS(new_theme) {
    if (new_theme == 'bootstrap') {
        $('#bootswatch_theme_stylesheet').attr('href', '');
    } else {
        $('#bootswatch_theme_stylesheet').attr('href', 'https://stackpath.bootstrapcdn.com/bootswatch/4.3.1/' + new_theme + '/bootstrap.min.css');
    }

    $('#' + theme).removeClass('active').children('i').remove();
    $('#' + new_theme).addClass('active').append(' <i class="fas fa-check"></i>');
    theme = new_theme;
    localStorage.setItem('udst2_theme', theme);

    /**
     * we also update the PHP $_SESSION variable with the new theme name using AJAX POST
     */
    $.ajax({
        type:     'POST',
        url:      'ajax/update_theme.php',
        dataType: 'json',
        data: {
            new_theme: theme
        },
        success: function (json) {
            console.log('Switched to Bootswatch theme: ' + new_theme);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log(jqXHR);
        }
    });
}

/**
 * function to fetch controller debug details using AJAX when needed
 */
function fetchDebugDetails() {
    if (debug) {
        $.ajax({
            type:     'POST',
            url:      'ajax/show_api_debug.php',
            dataType: 'html',
            success:  function (data) {
                if (data != 'ignore') {
                    console.log('Debug messages as returned by the cURL request to the UniFi controller API:');
                    console.log(data);
                }
            }
        });
    }
}

/**
 * function to render an alert containing a customized message
 */
function renderGeneralErrorAlert(error_message) {
    /**
     * hide any existings alerts
     */
    $('.alert_wrapper').addClass('d-none');

    /**
     * render the alert
     */
    $('#general_error_alert_wrapper').removeClass('d-none');
    $('#general_error').html('We encountered the following error: ' + error_message);
}

/**
 * function to fetch controller details and PHP memory usage and push to the About modal
 */
function updateAboutModal() {
    /**
     * we fetch the metrics
     */
    $.ajax({
        type:     'GET',
        url:      'ajax/fetch_about_modal_metrics.php',
        dataType: 'json',
        success: function (json) {
            $('#span_controller_url').html(json.controller_url);
            $('#span_controller_user').html(json.controller_user);
            $('#span_controller_version').html(json.controller_version);
            $('#span_memory_used').html(json.memory_used);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log(jqXHR);
        }
    });
}

/**
 * we only update the About modal contents when we render the modal
 */
$('#about_modal').on('show.bs.modal', function (e) {
    updateAboutModal();
})

/**
 * initialize Bootstrap 4 tooltips and popovers
 *
 * NOTE:
 * boundary setting prevents tooltips/popovers from flickering in certain cases
 */
$('[data-toggle="tooltip"]').tooltip({
    trigger:   'hover',
    container: 'body',
    boundary:  'window'
});

$('[data-toggle="popover"]').popover({
    trigger:   'hover',
    container: 'body',
    boundary:  'window'
});

/**
 * manage display of the "back to top" button element
 */
$(window).scroll(function () {
    if ($(this).scrollTop() > 50) {
        $('#back-to-top').fadeIn();
    } else {
        $('#back-to-top').fadeOut();
    }
});

/**
 * scroll body to 0px (top) on click on the "back to top" button
 */
$('#back-to-top').click(function () {
    $('#back-to-top').tooltip('hide');
    $('body,html').animate({
        scrollTop: 0
    }, 500);

    return false;
});
