<?php
/**
 * UniFi Device Search tool
 *
 * Copyright (c) 2020, Art of WiFi, info@artofwifi.net
 *
 * This source file is part of the UniFi Device Search tool and is subject to the MIT license that is bundled
 * with this package in the file LICENSE.md.
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/**
 * load required packages using the composer autoloader together with the file containing shared functions
 */
require_once('../common.php');
require_once('../vendor/autoload.php');

/**
 * load the configuration file if readable
 */
if (is_file('../config/config.php') && is_readable('../config/config.php')) {
    include('../config/config.php');
} else {
    die();
}

/**
 * initialize the Twig loader
 */
$loader = new \Twig\Loader\FilesystemLoader('../templates');
$twig   = new \Twig\Environment($loader);

/**
 * check variables and assign default values if not present in the config.php file
 */
if (empty($totals_fetch_interval)) {
    $totals_fetch_interval = 60;
}

if (empty($enable_all_devices_table)) {
    $enable_all_devices_table = true;
}

if (empty($use_regex_filter)) {
    $use_regex_filter = true;
}

if (empty($max_execution_time)) {
    $max_execution_time = 600;
}

if (empty($enable_all_devices_table)) {
    $unknown_string = 'unknown';
}

if (empty($ajax_max_conc)) {
    $ajax_max_conc = 6;
}

if ($debug === true) {
    $debug = 1;
} else {
    $debug = 0;
}

/**
 * render the results as Javascript content
 */
header('Content-Type: application/javascript');

echo $twig->render('js/config.js.twig', [
    'totals_fetch_interval'    => $totals_fetch_interval,
    'enable_all_devices_table' => $enable_all_devices_table,
    'use_regex_filter'         => $use_regex_filter,
    'max_execution_time'       => $max_execution_time,
    'unknown_string'           => $unknown_string,
    'ajax_max_conc'            => $ajax_max_conc,
    'debug'                    => $debug,
    'tool_version'             => TOOL_VERSION,
]);

ob_end_flush();