<?php
/**
 * UniFi Device Search tool
 *
 * Copyright (c) 2020, Art of WiFi, info@artofwifi.net
 *
 * This file is part of the UniFi Device Search tool and is subject to the MIT license that is bundled
 * with this package in the file LICENSE.md.
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/**
 * Configuration instructions
 * ===========================
 * Create a copy of this configuration template file within the same directory, name it config.php and enter your
 * UniFi controller details and credentials below
 *
 * Multi controller configuration options
 * =======================================
 * The number of UniFi controllers that can be added is unlimited, just take care to correctly maintain
 * the array structure by following PHP syntax shown below.
 *
 * **All fields are required for each controller**
 *
 * If a controller configuration is incomplete, an error will the thrown upon selection
 */
$controllers = [
    [
        'user'     => 'demo', // the user name for access to the Unifi Controller
        'password' => 'demo', // the password for access to the Unifi Controller
        'url'      => 'https://demo.ui.com:443', // full url to the Unifi Controller, eg. 'https://22.22.11.11:8443'
        'name'     => 'demo.ubnt.com' // name for this controller which will be used in the dropdown menu
    ],
    [
        'user'     => 'demo2', // the user name for access to the UniFi Controller
        'password' => 'demo2', // the password for access to the UniFi Controller
        'url'      => 'https://demo.ui.com:443', // full url to the UniFi Controller, eg. 'https://22.22.11.11:8443'
        'name'     => 'demo2.ubnt.com'  // name for this controller which will be used in the dropdown menu
    ],
];

/**
 * Optionally change the values for options below
 */

/**
 * your default theme of choice, please select one from the list below:
 * bootstrap, cerulean, cosmo, cyborg, darkly, flatly, journal, lumen, paper, readable,
 * sandstone, simplex, slate, spacelab, superhero, united, yeti
 */
$theme = 'bootstrap';

/**
 * class for the main navigation bar which determines the font colors used in the navigation bar, valid options are:
 * light, dark
 *
 * see details here:
 * https://getbootstrap.com/docs/4.0/components/navbar/#color-schemes
 */
$navbar_class = 'dark';

/**
 * class for the main navigation bar background, valid options are:
 * light/dark (matching the above option value) or primary, secondary, success, danger, warning, info, white, transparent
 *
 * see details here:
 * https://getbootstrap.com/docs/4.0/components/navbar/#color-schemes
 */
$navbar_bg_class = 'dark';

/**
 * when set to true all device tables will be more compact and have less styling applied,
 * default value is false (regular padding and styling is applied)
 */
$compact_tables = false;

/**
 * set to true (without quotes) to enable debug output to the browser and the PHP error log
 * when fetching the sites collection after selecting a controller
 */
$debug = false;

/**
 * Determine how frequent the refresh of the controller totals should be,
 * value in seconds
 */
$totals_fetch_interval = 60;

/**
 * Expert use only!
 *
 * Enable regex based searched in tables (field at the top right-hand corner of each table)?
 * When using regex-based search view the browser console for any regex errors
 *
 * This feature disables Datatables' smart search.
 */
$use_regex_filter = false;

/**
 * Maximum execution time for various scripts, defined in seconds, after which they will be terminated
 * only increase this value for extremely large controller environments
 */
$max_execution_time = 600;

/**
 * String to insert in table results when a device attribute is unknown or unavailable
 */
$unknown_string = 'unknown';

/**
 * Maximum number of concurrent AJAX requests allowed, 4 is default which will work with most browsers
 */
$ajax_max_conc = 4;

/**
 * Enable the tables which contains all devices, for controllers with a high volume of devices (6000+)
 * you may consider setting this variable to false
 */
$enable_all_devices_table = true;