<?php
/**
 * UniFi Device Search tool
 *
 * Copyright (c) 2020, Art of WiFi, info@artofwifi.net
 *
 * This source file is part of the UniFi Device Search tool and is subject to the MIT license that is bundled
 * with this package in the file LICENSE.md.
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/**
 * load required file containing shared functions
 */
require_once('../common.php');

/**
 * load the configuration file if readable
 */
if (is_file('../config/config.php') && is_readable('../config/config.php')) {
    include('../config/config.php');
} else {
    die();
}

/**
 * in order to use the PHP $_SESSION array for temporary storage of variables, session_start() is required
 */
session_start();

/**
 * initialize the results array
 */
$results = [
    'state'   => 'success',
    'message' => 'theme updated'
];

/**
 * get the POSTed new theme to store in the global $_SESSION variable
 */
/**
 * get the POST parameters that were passed by the calling AJAX function
 */
if (!empty($_POST['new_theme'])) {
    $_SESSION['udst2']['theme']  = $_POST['new_theme'];
} else {
    $results['state']   = 'error';
    $results['message'] = 'empty POST';
}

$_SESSION['udst2']['memory_used'] = round(memory_get_peak_usage(false) / 1024 / 1024, 2) . 'M';

if ($debug) {
    error_log('UDST DEBUG: ' . pathinfo($_SERVER['SCRIPT_FILENAME'], PATHINFO_FILENAME) . ', peak memory used is ' . $_SESSION['udst2']['memory_used']);
}

/**
 * output the results with correct JSON formatting
 */
header('Content-Type: application/json; charset=utf-8');
echo (json_encode($results));

ob_end_flush();