<?php
/**
 * UniFi Device Search tool
 *
 * Copyright (c) 2020, Art of WiFi, info@artofwifi.net
 *
 * This source file is part of the UniFi Device Search tool and is subject to the MIT license that is bundled
 * with this package in the file LICENSE.md.
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/**
 * load the file containing shared functions
 */
require_once('../common.php');

/**
 * load the configuration file if readable
 */
if (is_file('../config/config.php') && is_readable('../config/config.php')) {
    include('../config/config.php');
} else {
    die();
}

/**
 * in order to use the PHP $_SESSION['udst2'] array for temporary storage of variables, session_start() is required
 */
session_start();

/**
 * initialize the results array
 */
$results = [
    'controller_url'     => 'unknown',
    'controller_user'    => 'unknown',
    'controller_version' => 'not detected',
    'memory_used'        => $_SESSION['udst2']['memory_used'] ?: $unknown_string,
];

/**
 * and fill in the details for the controller if available
 */
if (!empty($_SESSION['udst2']['controller'])) {
    $results['controller_url']  = $_SESSION['udst2']['controller']['url'] ?: $unknown_string;
    $results['controller_user'] = $_SESSION['udst2']['controller']['user'] ?: $unknown_string;

    if (!empty($_SESSION['udst2']['controller']['detected_version'])) {
        $results['controller_version'] = $_SESSION['udst2']['controller']['detected_version'] ?: $unknown_string;
    }
}

/**
 * output the results with correct JSON formatting
 */
header('Content-Type: application/json; charset=utf-8');
echo (json_encode($results));

ob_end_flush();