## UniFi Device Search tool

Are you managing multiple sites on one or more UniFi controllers and have you ever spent too much time searching for a specific device? Or did you ever attempt to export the details and serial numbers of the devices you manage to an Excel sheet? That's where our UniFi device search tool comes in handy and saves you time.

The UniFi Device Search tool was specifically developed to quickly find a single UniFi device, or a group of devices, across all sites on a UniFi controller by using multiple filters and a search option. The results can quickly be exported to CSV and Excel.

This tool leverages Ubiquiti's UniFi Controller API and is written in PHP, JavaScript and the [Bootstrap](http://getbootstrap.com/) CSS framework.

Please keep the following in mind:

- currently, versions 4.x.x and 5.x.x of the UniFi Controller software are supported (version 5.12.35 has been confirmed to work)
- we are looking to continuously add/improve functionality and usability of this tool so suggestions/comments are very welcome. Please email us (info@artofwifi.net) or ping us on the Ubiquiti Community forums using @slooffmaster to share your ideas/questions.
- please read the Security Notice below before installing this tool!


### Upgrading from 1.X to 2.X

Because the directory structure and the structure of the configuration file have changed, we recommend performing a fresh install when upgrading from 1.X to 2.X.


### Features

The UniFi Device Search tool offers the following features:

- quickly find a single UniFi device or a group of UniFi devices, across all sites on a UniFi controller by using multiple filters and the search option
- results can quickly be exported to CSV and Excel
- toggle column visibility
- reset all filters and search strings with a single button click
- easily switch between controllers that are set up in your configuration file
- switch between default Bootstrap theme and the [Bootswatch](https://bootswatch.com/) themes
- responsive UI which allows the tool to work well on mobile devices as well as large screens
- very easy setup with minimal dependencies
- debug mode to troubleshoot cURL connections (set `$debug` to `true` in the config file to enable debug mode)


### Requirements

- a web server with PHP and cURL modules installed (confirmed to work on Apache with PHP Version 5.6.32 and cURL 7.29.0 and with PHP 7.2.5 and cURL 7.60.0)
- network connectivity between this web server and the server (and port) where the UniFi controller is running (in case you are seeing errors, please check out [this issue](https://github.com/Art-of-WiFi/UniFi-API-browser/issues/4))
- clients using this tool should have internet access because several CSS and JS files are loaded from public CDNs.


### Installation

Installation of this tool is quite straightforward. Simply download the zip file and unzip it in your directory of choice somewhere in the folder structure of your web server, then follow the configuration steps below.


### Configuration

- credentials for access to the UniFi Controller API need to be configured in a copy of the file named `config/config-template.php` which should be copied/renamed to `config/config.php` before using the UniFi Device Search tool
- you can store multiple controller configurations in the `config/config.php` file
- please refer to the comments in the `config/config-template.php` file for further instructions
- after following these steps, you can open the tool in your web browser of choice (assuming you installed it in the root folder of your web server as suggested above) by going to this url: `http://<server IP address or FQDN>/<folder where you installed the tool>/`


### Security notice

We **highly recommend** enabling the user name/password authentication feature by creating a `config/users.php` based on the included `config/users-template.php` file. When creating passwords and their SHA512 hashes for entry in the `config/users.php` file, please make sure to use **strong random passwords**.

Please refer to the instructions in the `config/users-template.php` file for further details

It is your own responsibility to implement the necessary additional controls in securing this application and preventing unwanted access.


### Known issues

- when a table column contains very long strings when using a wide browser window, column contents may overlap. Reducing the browser window width sometimes fixes this.


### Credits

Included libraries:

- Bootstrap 4 https://getbootstrap.com
- Bootswatch themes https://bootswatch.com/
- Font-awesome icons https://fontawesome.github.io/Font-Awesome
- jQuery https://jquery.com
- jQuery Datatables https://datatables.net/
- JSZip https://stuk.github.io/jszip/
- lodash https://lodash.com
- nanobar https://github.com/jacoborus/nanobar
- Select2 https://select2.org/
- Moment.js https://momentjs.com/
- pdfmake http://pdfmake.org/
- Twig template engine https://twig.symfony.com
- UniFi Controller API client class https://github.com/Art-of-WiFi/UniFi-API-client